//+------------------------------------------------------------------+
//|                                                     AIS HiLo.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "HiLo"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ushort iPeriod=24;

int period;
double buffer[],arrayh[],arrayl[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   period=MathMax(2,iPeriod);

   ArrayResize(arrayh,period);
   ArrayResize(arrayl,period);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(high,true);
      ArraySetAsSeries(low,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-period-1;

      for(int i=bars;i>0;i--)
        {
         double max=0,min=DBL_MAX;

         for(int j=0;j<period;j++)
           {
            int p=i+j;
            if(max<high[p])
               max=high[p];
            if(min>low[p])
               min=low[p];
           }

         for(int j=period-1;j>0;j--)
           {
            int p=j-1;
            arrayh[j]=arrayh[p];
            arrayl[j]=arrayl[p];
           }
         arrayh[0]=max;
         arrayl[0]=min;

         max=DBL_MAX;
         min=0;

         for(int j=0;j<period;j++)
           {
            if(max>arrayh[j])
               max=arrayh[j];
            if(min<arrayl[j])
               min=arrayl[j];
           }

         buffer[i-1]=(max+min)/2;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
